/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.render.infobar;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.client.render.infobar.DataSourcedElement;
import java.util.function.Function;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class DataRowElement<T>
extends DataSourcedElement<T> {
    private final ITextComponent column1;
    private final Function<T, ITextComponent> column2Provider;
    private int width;

    public DataRowElement(T dataSource, ITextComponent column1, Function<T, ITextComponent> column2Provider) {
        super(dataSource);
        this.column1 = column1;
        this.column2Provider = column2Provider;
    }

    @Override
    public void draw(MatrixStack matrix, FontRenderer font, int x, int y, int width, int height) {
        this.calculateDimensions(font);
        font.func_243248_b(matrix, this.column1, (float)x, (float)y, 0xFFFFFF);
        Object src = this.getDataSource();
        ITextComponent col2 = this.column2Provider.apply(src);
        int col2Width = font.func_238414_a_((ITextProperties)col2);
        font.func_243248_b(matrix, col2, (float)(x + width - col2Width - 3), (float)y, 0xFFFFFF);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return 10;
    }

    private void calculateDimensions(FontRenderer font) {
        Object source = this.getDataSource();
        ITextComponent column2 = this.column2Provider.apply(source);
        int leftWidth = font.func_238414_a_((ITextProperties)this.column1);
        int spacing = 15;
        int rightWidth = font.func_238414_a_((ITextProperties)column2);
        this.width = leftWidth + spacing + rightWidth;
    }
}

